<?php
// /api/update_item.php (REVISED WRAPPER)
// Original API endpoint, now calls the refactored logic in xo_common.php
// Supports both direct HTTP POST and internal tool call via $XO_PAYLOAD.

require_once __DIR__ . '/xo_common.php';

// ===== HTTP / CORS HEADERS (Original Headers) =====
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); exit; }

// --- Get Data from Request Body (Dual-purpose input fix) ---
global $XO_PAYLOAD;

if (isset($XO_PAYLOAD) && is_array($XO_PAYLOAD)) {
    // 1. Running as a tool call from chat.php
    $data = $XO_PAYLOAD;
} else {
    // 2. Running as a standard HTTP POST from the browser
    $raw  = file_get_contents('php://input');
    $data = json_decode($raw, true);
}

$category = $data['category'] ?? null;
$id       = $data['id'] ?? null;
$patch    = $data['patch'] ?? null;

if (empty($category) || !is_numeric($id) || !is_array($patch)) {
    http_response_code(400);
    xo_respond(['success' => false, 'error' => 'invalid_payload']);
}

// --- Call the new core logic function ---
// xo_update_item_logic handles all file R/W, logging, and error handling.
$result = xo_update_item_logic($category, (int)$id, $patch);

// --- Respond based on result ---
if ($result['success'] === false) {
    // Use 404 if item not found, 400 for bad category, 500 for save failure
    if ($result['error'] === 'item_not_found') {
        http_response_code(404);
    } else {
        http_response_code(400);
    }
}
xo_respond($result);