<?php
// connection_test.php
// Checks basic network connectivity and file loading

ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h2>Connection Test Results</h2>";
echo "<p>Test 1: Vendor Autoload...</p>";
try {
    require __DIR__ . '/../vendor/autoload.php';
    echo "<p style='color:green;'>✅ Autoload Success!</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Autoload Failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<hr>";
echo "<p>Test 2: Basic cURL to Google...</p>";

$ch = curl_init('https://www.google.com/');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$result = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($httpCode == 200) {
    echo "<p style='color:green;'>✅ cURL Connection Success! HTTP Status: $httpCode</p>";
    echo "<p>This confirms your server can talk to the internet.</p>";
} elseif (!empty($error)) {
    echo "<p style='color:red;'>❌ cURL Connection FAILED: $error</p>";
    echo "<p><strong>ACTION:</strong> Your hosting provider may be blocking outbound connections. Contact support or use an API proxy.</p>";
} else {
    echo "<p style='color:red;'>❌ cURL Connection FAILED: HTTP Status: $httpCode</p>";
    echo "<p>The connection was made, but the status was unexpected. Your server may have a firewall issue.</p>";
}

echo "<hr>";
echo "<p>Test 3: Checking required PHP extensions...</p>";
$required_extensions = ['curl', 'json', 'openssl', 'pcre', 'spl', 'zlib'];
$missing = [];
foreach ($required_extensions as $ext) {
    if (!extension_loaded($ext)) {
        $missing[] = $ext;
    }
}

if (empty($missing)) {
    echo "<p style='color:green;'>✅ All required extensions loaded.</p>";
} else {
    echo "<p style='color:red;'>❌ Missing PHP extensions: " . implode(', ', $missing) . "</p>";
    echo "<p><strong>ACTION:</strong> You must enable these extensions in your hosting control panel (often called 'Select PHP Version' or 'PHP Selector').</p>";
}

echo "<hr>";
echo "<p>Test 4: PHP Version Check...</p>";
$current_version = PHP_VERSION;
if (version_compare($current_version, '8.1.0', '>=')) {
    echo "<p style='color:green;'>✅ PHP Version $current_version is compatible.</p>";
} else {
    echo "<p style='color:orange;'>⚠️ PHP Version $current_version. The Google Client recommends PHP 8.1 or higher. Please upgrade if possible.</p>";
}

?>