<?php
// add_project.php
// Safely append a new project into xo_memory.json without touching other data.

ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once __DIR__ . '/xo_common.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    xo_respond(['success' => false, 'error' => 'Method not allowed'], 405);
}

// Parse JSON body
$raw   = file_get_contents('php://input');
$input = json_decode($raw, true);

if (!is_array($input)) {
    xo_log('add_project', 'error', ['reason' => 'invalid_json', 'body' => $raw]);
    xo_respond(['success' => false, 'error' => 'Invalid JSON body'], 400);
}

// Required: name
$name = trim($input['name'] ?? '');
if ($name === '') {
    xo_log('add_project', 'error', ['reason' => 'missing_name', 'input' => $input]);
    xo_respond([
        'success' => false,
        'error'   => 'Missing required field: name',
        'code'    => 'VALIDATION_ERROR'
    ], 400);
}

// Optional fields
$dueDate = $input['dueDate'] ?? null; // ISO date string or null
$source  = $input['source']  ?? 'XO';
$actor   = $source ?: 'XO';

// 1) Load existing memory
$memory = xo_load_memory();

// 2) Ensure projects array exists
if (!isset($memory['data']['projects']) || !is_array($memory['data']['projects'])) {
    $memory['data']['projects'] = [];
}

// 3) Build new project with server-owned id
$newId = xo_next_id($memory['data']['projects']);

$newProject = [
    'id'      => $newId,
    'name'    => $name,
    'dueDate' => $dueDate
];

// 4) Append and write back
$memory['data']['projects'][] = $newProject;

xo_write_memory($memory, $actor);

// 5) Log and respond
xo_log('add_project', 'success', ['id' => $newId, 'name' => $name]);

xo_respond([
    'success'       => true,
    'action'        => 'add_project',
    'project'       => $newProject,
    'lastUpdatedAt' => $memory['lastUpdatedAt'] ?? null
]);
