<?php
// /api/add_item.php (REVISED WRAPPER)
// Original API endpoint, now calls the refactored logic in xo_common.php
// Supports both direct HTTP POST and internal tool call via $XO_PAYLOAD.

require_once __DIR__ . '/xo_common.php';

// ===== HTTP / CORS HEADERS (Original Headers) =====
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); exit; }

// --- Get Data from Request Body (Dual-purpose input fix) ---
global $XO_PAYLOAD;

if (isset($XO_PAYLOAD) && is_array($XO_PAYLOAD)) {
    // 1. Running as a tool call from chat.php
    $data = $XO_PAYLOAD;
} else {
    // 2. Running as a standard HTTP POST from the browser
    $raw  = file_get_contents('php://input');
    $data = json_decode($raw, true);
}

$category = $data['category'] ?? null;
$item     = $data['item'] ?? null;

if (empty($category) || !is_array($item)) {
    http_response_code(400);
    xo_respond(['success' => false, 'error' => 'invalid_payload']);
}

// --- Call the new core logic function ---
// xo_add_item_logic now handles all file R/W, logging, and error handling.
$result = xo_add_item_logic($category, $item);

// --- Respond based on result ---
if ($result['success'] === false) {
    // Use 400 for bad requests (like unknown category), 500 for server issues
    http_response_code(400); 
}
xo_respond($result);